#include <iostream>
#include <cstdio>
#include <algorithm>
#include <vector>
#include <stack>
#include <queue>
#include <set>
#include <cassert>
using namespace std;

typedef long long ll;
typedef pair<int, int> ii;
typedef vector<ii> vii;
typedef vector<int> vi;

template <class T> int size(const T &x) { return x.size(); }

const ll DINF = 10000000000000LL;
const ll mod = 2147483647;

ll *dist;

struct cmp {
    bool operator ()(int i, int j) {
        if (dist[i] != dist[j]) return dist[i] < dist[j];
        return i < j;
    }
};

ll *cnt, *revcnt;
int n;
ll docnt(int at, int t, vii *adj, ll *mem) {
    if (mem[at] != -1)
        return mem[at];

    if (at == t)
    {
        return mem[at] = 1;
    }

    ll res = 0;
    for (int i = 0; i < adj[at].size(); i++) 
    {
        res += docnt(adj[at][i].first, t, adj, mem);
        res %= mod;
        //if (res >= mod)
        //{
        //    res -= mod;
        //}
    }

    return mem[at] = res;
}

int main() {

    // REMEMBER: Bidirectional

    int m;
    scanf("%d %d\n", &n, &m);
    dist = new ll[n];
    for (int i = 0; i < n; i++) {
        dist[i] = DINF;
    }

    vector<pair<ii, int> > edges(m);
    vii *adj = new vii[n];
    for (int i = 0; i < m; i++) 
    {
        int a, b, c;
        scanf("%d %d %d\n", &a, &b, &c);
        a--, b--;
        edges[i] = make_pair(ii(a, b), c);
        adj[a].push_back(ii(b, c));
        adj[b].push_back(ii(a, c));
    }

    set<int, cmp> S;
    dist[0] = 0;
    S.insert(0);

    while (!S.empty()) {
        int cur = *S.begin();
        S.erase(S.begin());

        for (int i = 0; i < adj[cur].size(); i++) 
        {
            int nxt = adj[cur][i].first;
            int len = adj[cur][i].second;
            int ndist = dist[cur] + len;
            if (ndist < dist[nxt]) {
                S.erase(nxt);
                dist[nxt] = ndist;
                S.insert(nxt);
            }
        }
    }

    assert(dist[n - 1] != DINF);

    vii *spath = new vii[n];
    vii *rpath = new vii[n];

    for (int cur = 0; cur < n; cur++) {
        for (int j = 0; j < size(adj[cur]); j++) {
            int nxt = adj[cur][j].first;
            int len = adj[cur][j].second;
            if (dist[cur] + len == dist[nxt]) {
                spath[cur].push_back(ii(nxt, len));
                rpath[nxt].push_back(ii(cur, len));
            }
        }
    }

    cnt = new ll[n];
    revcnt = new ll[n];
    for (int i = 0; i < n; i++) {
        cnt[i] = -1;
        revcnt[i] = -1;
    }

    docnt(0, n - 1, spath, cnt);
    docnt(n - 1, 0, rpath, revcnt);

    vi important;
    for (int i = 0; i < m; i++) {
        int a = edges[i].first.first,
            b = edges[i].first.second;

        if ((revcnt[a] * cnt[b]) % mod == cnt[0]) {
            important.push_back(i+1);
        }
    }

    //for (int i = 0; i < n; i++) {
    //    cout << (i+1) << " " << cnt[i] << " " << revcnt[i] << endl;
    //}

    printf("%d\n", important.size());
    for (int i = 0; i < important.size(); i++) 
    {
        if (i != 0) printf(" ");
        printf("%d", important[i]);
    }

    printf("\n");

    return 0;
}
